	function Pap = EQ_PARAM_P_Z(X, Nap)
	
	% 	Convert optimization parameter to allpass poles
	% 	Used in EQ_TG_LP_Z and EQ_AP_LP_Z
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar, 2010-10-11
    % 	Modified by:		 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1	
	% 	Known bugs: 
	% 	Report bugs to:	Wanhammar@gmail.com
	
	if mod(Nap,2) == 1 % Convert real parameters, X, to poles
		Pap(Nap) = X(Nap);
	end
	for n = 1:2:Nap	- mod(Nap,2)
		temp1 = (1 - X(n))*X(n+1);
		temp2 = sqrt(temp1^2 + 4*X(n));
		Pap(n) = 0.5*(temp1 - temp2);
		Pap(n+1) = 0.5*(temp1 + temp2);
	end
	return	
	
